<?php
	// Display Errors
	ini_set('display_startup_errors',1);
	ini_set('display_errors',1);
	error_reporting(-1);

	$album_string = file_get_contents('http://ws.spotify.com/lookup/1/.json?uri=spotify:album:3ANdSMSAOVWtpedwdPPcu2&extras=trackdetail');
	$album = json_decode($album_string)->album;
	$tracks = $album->tracks;
?>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="utf-8">
		<title><?=$album->name?> – <?=$album->artist?></title>
	</head>
	<body>
		<h1 class="album-title"><?=$album->name?></h1>
		<h2 class="artist"><?=$album->artist?></h2>
		<h3 class="year"><?=$album->released?></h3>
		<ul>
		<?php
			foreach ($tracks as $track) {
				$duration = gmdate('m:s',$track->length);
				echo '<li>';
				echo '<a href="'.$track->href.'">';
				echo $track->{'track-number'};
				echo ' ';
				echo $track->name;
				echo ' ('.$duration.')';
				echo '</a>';
				echo '</li>';
			}
		?>
		</ul>
		<p>“This product uses a SPOTIFY API but is not endorsed, certified or otherwise approved in any way by Spotify. Spotify is the registered trade mark of the Spotify Group.”</p>
	</body>
</html>