
/*
 *
 *  (c) BU Three Dimensional WS13/14
 *
 *
*/



var container = document.getElementById("container");


var renderer = new THREE.WebGLRenderer({ antialias: true });
// var renderer = new THREE.CanvasRenderer();
renderer.setSize(container.offsetWidth, container.offsetHeight);
container.appendChild( renderer.domElement );


var scene = new THREE.Scene();


var camera = new THREE.PerspectiveCamera( 45, container.offsetWidth / container.offsetHeight, 1, 4000 );
camera.position.set( 0, 2, 10 );
scene.add( camera );


var light = new THREE.DirectionalLight( 0xffffff, 1.5);
light.position.set(0, 1, 1);
scene.add( light );





var material = new THREE.MeshLambertMaterial({ color: "#188AE7" });

var mesh = new THREE.Mesh();

loader = new THREE.JSONLoader();
loader.load("model/myModel.js", onLoaderComplete)

function onLoaderComplete(geometry){
  mesh = new THREE.Mesh(geometry, material);
  scene.add(mesh);
}





loop();
function loop(){
  requestAnimationFrame( loop );
  renderer.render(scene, camera);
}










window.onresize = function() {

  $("canvas")[0].width = container.offsetWidth;
  $("canvas")[0].height = container.offsetHeight;
  
  renderer.setSize(container.offsetWidth, container.offsetHeight);
  camera.aspect = container.offsetWidth / container.offsetHeight;
  camera.updateProjectionMatrix();
}














/*

###### SNIPPETS ###########



// load external model

var mesh = new THREE.Mesh();

loader = new THREE.JSONLoader();
loader.load("model/myModel_3_uvmap.js", onLoaderComplete)

function onLoaderComplete(geometry){
  mesh = new THREE.Mesh(geometry, material);
}






// load external texture material

var map = THREE.ImageUtils.loadTexture("models/texture.png");
var material = new THREE.MeshPhongMaterial({ map: map });

material.side = THREE.DoubleSide;








// jquery Variable Counter

$({meineVar:1}).animate({meineVar:0},{
  step: function(){
  }
})






*/