// Track where a user is in an article, and bring them back there if they come back to it.
rdb.readProgress = {
    readPercent: 0,

    updateReadPercent: function () {
        // For a minor performance gain, we could pull viewportHeight and documentHeight out, and update them onResize.
        // If scrolling begins to seem laggy, do this.
        var scrollTop = $(window).scrollTop(),
            viewportHeight = $(window).height(),
            documentHeight = $(document).height();

        if (scrollTop + viewportHeight >= documentHeight) {
            // We've reached the end of the page. Set readPercent to 1 (done)
            rdb.readProgress.readPercent = 1;
        }
        else {
            rdb.readProgress.readPercent = scrollTop / documentHeight;
        }
    },

    // Send our read percent to the server for recording.
    sendReadPercent: function () {
        rdb.readProgress.updateReadPercent();

        if (isNaN(rdb.readProgress.readPercent)) {
            return false;
        }

        $.ajax({
            url: '/articles/' + rdb.utilities.articleId + '/ajax/read_percent/',
            type: 'POST',
            data: {
                'read_percent': rdb.readProgress.readPercent
            },
            async: false
        });

        return;
    },

    jumpToReadPercent: function () {
        if (this.readPercent && this.readPercent < 1.0) {
            var scrollToInPixels = $(document).height() * this.readPercent;

            if (scrollToInPixels > 0) {
                $('html, body').animate({'scrollTop': scrollToInPixels}, 'slow');
            }
        }
    },

    init: function () {
        this.readPercent = parseFloat($('article.hentry').attr('data-read-percent'));

        // Send the read percent on unload. Make sure we're not in mobile view before we run it.
        if ($('div[data-role="page"]').length === 0 && rdb.utilities.user.id !== false) {
            $(window).unload(this.sendReadPercent);
            this.jumpToReadPercent();
        }

    }
};

$(function() {
    rdb.readProgress.init();
});