// These next few functions are in the global scope, this is not the best way
// to do things, but because we own that damn global scope we're gonna do whatever
// we want until we have to implement a better solution.

// Flyout elements that are used for the appearance and send to kindle on
// Reading View and the Add Bookmark on the Reading List
var flyouts = function () {
    function openFlyout (target) {
        var targetFlyout = $(target.attr('data-flyout-selector')),
            // If a flyout is opened by one target, but needs to be associated
            // with a different target, specify a data-flyout-target
            targetOverride = $(target.attr('data-flyout-target'));

        if (targetOverride.length) {
            target = targetOverride;
        }

        // Small screen touch devices were having trouble with inputs and textarea
        // in the fixed position flyouts. add/remove a special class to change
        // the position to absolute.
        if (rdb.getScreenSize() === 'small' && Modernizr.touch) {
            targetFlyout.find('input, textarea').on('focus', function (e) {
                targetFlyout.addClass('text-input-focused');
            })
            .on('blur', function (e) {
                targetFlyout.removeClass('text-input-focused');
            });
        }

        // We need to make an association between the triggering element and
        // the flyout element
        targetFlyout.data('triggerEl', target);

        function hideFlyout () {
            target.removeClass('active');
            targetFlyout.addClass('hidden').removeAttr('style');

            $('body').trigger('closed.flyout');
        }

        function showFlyout () {
            target.addClass('active');
            targetFlyout.removeClass('hidden');

            $('body').trigger('opened.flyout', [target, targetFlyout]);
        }

        function positionFlyout () {
            var targetPos = target.position();

            targetFlyout.css({
                'left': targetPos.left + target.width(),
                'top': targetPos.top - target.height() * 0.8
            });
        }

        function closeOtherFlyouts () {
            $('.flyout').not('.hidden').addClass('hidden').removeAttr('style');
            $('.opens-flyout.active').removeClass('active');
        }

        if (targetFlyout.hasClass('hidden')) {
            if (!targetFlyout.hasClass('do-not-position') && rdb.getScreenSize() !== 'small') {
                positionFlyout();
            }
            else {
                targetFlyout.removeAttr('style');
            }

            closeOtherFlyouts();
            showFlyout();
        }
        else {
            hideFlyout();
        }
    }

    function closeFlyout (target) {
        var openFlyouts = $('.flyout').not('.hidden');

        // We need to make sure there are open flyouts before trying to close
        if (openFlyouts.length > 0) {
            // Check to make sure we're not clicking around inside the flyout,
            // that should not close anything.
            if (target.parents('.flyout').length === 0) {
                openFlyouts.addClass('hidden').removeAttr('style');

                var triggerEl = openFlyouts.data('triggerEl');

                if (triggerEl) {
                    triggerEl.removeClass('active');
                }

                $('body').trigger('closed.flyout');
            }
        }
    }

    // We're attaching this to the body because clicking outside of a flyout
    // needs to close it. Also, reasons.
    $('body').on('click.flyout', function (e) {
        var target = $(e.target);

        if (target.hasClass('opens-flyout')) {
            e.preventDefault();
            openFlyout(target);
        }
        else {
            // This may be a bit short-sighted. We want to be able to click an
            // item in any jquery ui autocomplete, so don't close the flyout.
            if (!target.parents('.ui-autocomplete').length) {
                closeFlyout(target);
            }
        }
    });

    $('body').on('keydown.flyout', function (e) {
        if (e.which === 27) {
            closeFlyout($('body'));
        }
    });

    $('body').on('flyout.close', function (e) {
        closeFlyout($('body'));
    });

    // Should probably use a debounce instead of this
    $(window).resize(function (e) {
        if (rdb.getScreenSize() !== 'small') {
            closeFlyout($('body'));
        }
    });
}();

// This can be used to add an article from another user's Reading List or
// Favorites, Top Reads, the Longform suggestions, etc.
// onComplete is a callback that will fire after the ajax POST
var addArticleToList = function (e, onComplete) {
    var el = $(e.currentTarget);

    // Kinda piss-poor error handling
    var error = function (data) {
        var msg = 'Mind trying again?';

        // TODO: This shouldn't happen.
        if (data.duplicate) {
            msg = 'In Reading List';
            el.addClass('in-list');
        }
        else {
            setTimeout(function () {
                el.text('Add to Reading List');
            }, 2500);
        }

        el.html(msg);
    };

    el.text('Adding...');

    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: el.attr('href'),
        data: {
            'strict_on_duplicate': 0
        },
        success: function (data) {
            if (data.success) {
                el.addClass('added').text('Added to Reading List');

                if ($.isFunction(onComplete)) {
                    onComplete(data.bookmark_id);
                }
            }
            else {
                error(data);
            }
        },
        error: error
    });
};

// This is in use on the Reading List and the Reading View.
var articleToEpub = function () {
    var isReadingList = $('body').attr('id') === 'reading-list';

    var tooltip = function () {
        return {
            // If this expands it should probably be a template
            el: '<div class="tooltip"><%= content %></div>',

            close: function () {
                $('.tooltip').remove();
                $('body').off('click.tooltip');
            },

            position: function (targetEl) {
                var targetPos = targetEl.position();

                this.$el.css({
                    'left': targetPos.left + targetEl.width(),
                    'top': targetPos.top
                });
            },

            render: function () {
                return this.el;
            }
        };
    };

    // This provides a little sexier of a download.
    var downloadEpub = function (e) {
        e.preventDefault();

        var el = $(e.target),
            requestAttempts = 0,
            maxAttempts = 10,
            url = el.attr('data-ajax-href');

        el.addClass('working');

        var requestError = function () {
            el.removeClass('working');

            var tip = new tooltip(),
                data = {
                    'content': 'There was an error creating your epub. Please try again.'
                };

            tip.$el = $(_.template(tip.render(), data));
            tip.position(el);
            tip.$el.addClass('before error');
            $('body').append(tip.$el);

            // A real stopgap fix for the positioning differences on the Reading list
            // TODO: Figure out a better way to handle this.
            if (isReadingList) {
                tip.$el.css({
                    'left': el.offset().left + el.width(),
                    'top': el.offset().top - el.height() * 0.25
                });
            }

            // This is a big bummer. This needs to be abstracted to the tooltip
            // level
            $('body').on('click.tooltip', tip.close);
        };

        var makeRequest = function () {
            $.ajax({
                type: 'GET',
                url: url,
                error: requestError,
                success: function (data) {
                    requestAttempts += 1;

                    if (data.url) {
                        el.removeClass('working');

                        // Redirect to trigger the download
                        window.location.href = data.url;
                    }
                    else {
                        // Try the request again
                        if (requestAttempts < maxAttempts) {
                            setTimeout(makeRequest, 1000);
                        }
                        else {
                            requestError();
                        }
                    }
                }
            });
        };

        makeRequest();
    };

    $('a.article-to-epub').on('click', downloadEpub);
}();

// These appear on the Top Reads list and other user's lists when authed
$('a.article-add').on('click', function (e) {
    var el = $(e.target);

    // Catch non-authenticated clicks on the add to reading list
    if (rdb.utilities.user.id === null) {
        rdb.openRegistrationModal('login', function (el) {
            el.find('input[name=next]').val(window.location.pathname);
        });

        return false;
    }

    // Bail if this is already in the list
    if (el.hasClass('added') || el.hasClass('in-list')) {
        return false;
    }

    e.preventDefault();
    addArticleToList(e);
});