rdb.article = {};

rdb.article.sidebar = {
    toggle: function (e) {
        if (e) {
            e.preventDefault();
        }

        var toolbar = $('aside.tools'),
            el = $('a.toolbar-visibility');

        toolbar.toggleClass('hidden');
        $('body').toggleClass('toolbar-hidden');

        if (toolbar.hasClass('hidden')) {
            el.attr('title', 'Show toolbar')
                .removeClass('icon-left-triangle')
                .addClass('icon-right-triangle');
            rdb.local_storage_set('toolbar_visibility', 'hidden');
        }
        else {
            el.attr('title', 'Hide toolbar')
                .removeClass('icon-right-triangle')
                .addClass('icon-left-triangle');
            rdb.local_storage_set('toolbar_visibility', 'visible');
        }
    },

    init: function () {
        var that = this,
            hentry = $('.hentry:first');

        $('a.toolbar-visibility').on('click', that.toggle);

        if (rdb.local_storage_get('toolbar_visibility') == 'hidden' || Modernizr.touch) {
            setTimeout(function () {
                $('a.toolbar-visibility').click();
            }, 300);
        }

        // Show/hide the toolbar on touch for devices that support it.
        if (Modernizr.touch) {
            hentry.on('click', function (e) {
                if (e.target.nodeName !== 'A') {
                    that.toggle();
                }
            });

            hentry.on('touchmove', function (e) {
                if (!$('body').hasClass('toolbar-hidden')) {
                    that.toggle();
                }
            });
        }

        $('body').on('toggleSidebar', that.toggle);
    }
};

// Loop through the images in the article, fixing their display - centering
// them, making sure that the figures look right if they have them, etc.
rdb.article.layoutImages = {

    imageWidthThreshold: null,

    imageHideThreshold: 30,

    layoutImage: function ($img) {
        var limg = rdb.article.layoutImages;

        // Even after load, some images were still reporting incorrect widths.
        // A .25 second timeout to let them settle themselves.
        window.setTimeout(function () {
            var width = $img.width(),
                height = $img.height(),
                $figure = $img.parents('figure'),
                inFigure = $figure.length > 0,
                figHeight;

            // If we have a class of no-hide or the image has no area, there's
            // nothing to fix.  In addition, the image may not have loaded
            // properly yet, so we should just leave it be.
            //
            // NOTE: This class is used a single place right now. It's used
            // on the little "ad" for nyreview of books
            if ($.img) {
                if($.img.is('.rdb-nohide') || !width || !height) {
                    return;
                }
            }

            if (inFigure) {
                // Center and lay out all figure tags, which need a wrapping
                // element to do so.
                $figure.wrap('<div class="figure-wrap" />');
            } else {
                // Decide whether to float or center the image.
                if (width > limg.imageWidthThreshold) {
                    $img.addClass("blockImage");
                } else {
                    $img.addClass("leftImage");
                }
            }

        }, 250);

    },

    init: function () {
        var limg = rdb.article.layoutImages,
            $article = $('.entry-content');

        limg.imageWidthThreshold = Math.min($article.width(), 800) * 0.55;
    }
};

rdb.article.pageFetcher = {
    pageCount: 1,

    appendPage: function (articleId, force) {
        var pf = rdb.article.pageFetcher;

        if (!force && pf.pageCount > 10) {
            var $nextPageLink = $('<a class="next-page-link" href="#">Read Next Page</a>');

            $nextPageLink.data('article-id', articleId);

            $('.entry-content').append($nextPageLink);

            return;
        }

        $.get("/articles/" + articleId + "/ajax/view/", function (responseObj, status, jqxhr) {
            var $nextPage;

            if (typeof responseObj.content === "undefined" || $.trim(responseObj.content) === "") {
                return false;
            }

            $nextPage = $(responseObj.content);

            $('.entry-content').append($nextPage);

            pf.pageCount++;

            if (responseObj.next_page) {
                return rdb.article.pageFetcher.appendPage(responseObj.next_page);
            }

        }, 'json');
    },


    init: function () {
        var nextPageId = $('article.hentry').attr('data-next-page-id') || '';

        $('a.next-page-link').on('click', function (e) {
            e.preventDefault();
            var pf = rdb.article.pageFetcher;

            pf.appendPage($(this).data('article-id'), true);

            $(this).hide();
        });

        if (nextPageId !== '') {
            rdb.article.pageFetcher.appendPage(nextPageId);
        }
    }
};

rdb.article.smoothScrolling = {
    reversePageScroll: false, // If they hold shift and hit space, scroll up
    scrollSpeed: 400,
    // The scrollable element, which changes depending on browser. Initialized via initScrollable.
    scrollable: null,

    // Detect which element to use for scrolling - html or body. Sets the scrollable attribute.
    // Derived from getScrollable, borrowed from jQuery Smooth Scroll by Karl Swedberg:
    // https://github.com/kswedberg/jquery-smooth-scroll/blob/master/jquery.smooth-scroll.js

    // @param els an array of elements to try to scroll upon - probably ['html','body']
    initScrollable: function (els) {
        var scrolled = false;

        for (var i=0, il=els.length; i<il; i++) {
            var tagName = els[i],
                el = $(tagName);

            if (el.scrollTop() > 0) {
                rdb.article.smoothScrolling.scrollable = el.get(0);
                break;
            }

            el.scrollTop(1);
            scrolled = el.scrollTop() > 0;
            el.scrollTop(0);

            if (scrolled) {
                rdb.article.smoothScrolling.scrollable = el.get(0);
                break;
            }
        }

        // If we weren't able to initialize the scrollable at all, fall back to 'html, body'.
        if (rdb.article.smoothScrolling.scrollable === null) {
            rdb.article.smoothScrolling.scrollable = $('html, body');
        }
    },

    // Are we already smooth scrolling the page?
    isAnimating: function () {
        return $(rdb.article.smoothScrolling.scrollable).is(':animated');
    },

    // Determine when to fade the scroll bullet.
    fadeBulletInterval: null,
    fadeBullet: function () {
        if (!rdb.article.smoothScrolling.isAnimating()) {
            $('#scroll-bullet').fadeOut('fast');
            clearInterval(rdb.article.smoothScrolling.fadeBulletInterval);
        }
    },

    // Initialize the smooth scrolling functionality.
    init: function () {
        var rdbss = rdb.article.smoothScrolling;

        rdbss.initScrollable(['html','body']);

        $(document).on('keydown.smoothScroll', function (e) {
            var code = (window.event) ? event.keyCode : e.keyCode,
                viewportHeight = $(window).height(),
                offset = $(window).scrollTop(),
                direction = 1,
                delta = viewportHeight - 50;

            if (code === 16) {
                rdbss.reversePageScroll = true;
                return;
            }

            if (code === 32) {
                // Don't steal the space bar if someone is inputting text
                if (!$(e.target).is('textarea') && !$(e.target).is('input')) {
                    if (rdbss.isAnimating()) {
                        return false;
                    }

                    direction = (rdbss.reversePageScroll) ? -1 : 1;

                    if (direction == 1) {
                        $('#scroll-bullet').css({
                            'opacity': 1,
                            'top': offset + (delta * direction),
                            'left': $('.entry-content').position().left - 25
                        }).show();
                    }

                    $(rdbss.scrollable).animate({
                        scrollTop: offset + (delta * direction)},
                        rdbss.scrollSpeed, function () {
                            rdbss.fadeBulletInterval = setInterval(rdbss.fadeBullet, 500);
                    });
                }
            }
        });

        $(document).on('keyup.smoothScroll', function (e) {
            var code = (window.event) ? event.keyCode : e.keyCode;

            if (code === 16) {
                rdbss.reversePageScroll = false;
                return;
            }
        });
    }
};

// Analyze the article text and determine if it should be right-to-left. If so, add classes to do so.
rdb.article.direction = {

    // Given a bit of text, analyze it for right-to-left style characters.
    // @param text string - the text to analyze
    // @return string rtl|ltr - the direction of the text.
    getSuggestedDirection: function (text) {
        function sanitizeText() {
            return text.replace(/@\w+/, "");
        }

        function countMatches(match) {
            var matches = text.match(new RegExp(match, "g"));
            return matches !== null ? matches.length : 0;
        }

        function isRTL() {
            var count_heb = countMatches("[\\u05B0-\\u05F4\\uFB1D-\\uFBF4]");
            var count_arb = countMatches("[\\u060C-\\u06FE\\uFB50-\\uFEFC]");

            // if 20% of chars are Hebrew or Arbic then direction is rtl
            return (count_heb + count_arb) * 100 / text.length > 20;
        }

        text  = sanitizeText(text);
        return isRTL() ? "rtl" : "ltr";
    },

    // If the article content looks to be right-to-left, add the right-to-left class to style it such.
    init: function () {
        var sample_html = $('h1.entry-title').text() + $('.entry-content p:lt(3)').text(),
            is_rtl = (rdb.article.direction.getSuggestedDirection(sample_html) === 'rtl');

        if (is_rtl) {
            $('section[role=main], h1.entry-title').addClass('right-to-left');
        }
    }
};

rdb.article.readLater = {

    readLater: function (e) {
        if (e) {
            e.preventDefault();
        }

        $.ajax({
            type: 'POST',
            url: '/articles/' + rdb.utilities.articleId + '/ajax/add',
            data: {
                'add': 1
            },
            success: function (res) {
                if (res.success || res.duplicate) {
                    $('.read-later-btn').addClass('added')
                        .html('<span></span>Saved')
                        .unbind('click');
                }
            },
            error: function (jqxhr) {
                if (jqxhr.status === 403) {
                    $.colorbox({
                        href: 'div.read-later-pitch-modal',
                        inline: true
                    });
                }
            }
        });
    },

    activateFormSubmit: function (e) {
        e.preventDefault();

        var el = $(e.target),
            fieldContainer = el.find('.activation-form-fields'),
            emailField = el.find('#login-modal-activation-email'),
            btn = el.find('input[type=submit]'),
            errorEl = emailField.parent().find('.error');

        function activityIndicator (action) {
            var actions = {
                'stop': function () {
                    fieldContainer.removeClass('working');
                    btn.removeClass('working')
                        .val(btn.attr('data-val'));
                },
                'start': function () {
                    fieldContainer.addClass('working');
                    btn.addClass('working')
                        .attr('data-val', btn.val())
                        .val(btn.attr('data-working-val'));
                }
            };

            actions[action]();
        }

        errorEl.addClass('hidden');
        activityIndicator('start');

        if (!emailField.get(0).checkValidity()) {
            var err = rdb.h5f.getFieldValidationMessage(emailField.get(0));

            errorEl.text(err).removeClass('hidden');
            activityIndicator('stop');
        }
        else {
            rdb.article.activator.activate({
                email: emailField.val(),
                success: function (res) {
                    emailField.parent().addClass('hidden');
                    $('.activation-success').removeClass('hidden');
                },
                error: function (res) {
                    var err = 'We\'re having some trouble. Mind trying again?';

                    if (res.errorCode === 409) {
                        err = 'That email address is already associated with an account.';
                    }

                    errorEl.text(err).removeClass('hidden');
                },
                complete: function () {
                    activityIndicator('stop');
                }
            });
        }
    },

    init: function () {
        var activationForm = $('#login-modal-activation-form');

        $('.read-later-btn').on('click', this.readLater);

        if (activationForm.length) {
            $('.activation-success').on('click', function (e) {
                e.preventDefault();
                $.colorbox.close();
            });

            rdb.h5f.loadPolyfill(function () {
                if (!rdb.h5f.hasSupport()) {
                    H5F.setup(activationForm.get(0));
                }
            });

            // Set novalidate to bypass the built in browser validation
            activationForm.attr('novalidate', 'novalidate')
                .on('submit', this.activateFormSubmit);
        }
    }
};

rdb.article.login = {
    formSubmit: function (e) {
        var el = $(e.target);

        if (!el.get(0).checkValidity()) {
            var fields = el.find('input')
                .not('[type=hidden], [type=submit], [type=checkbox]');

            // Hide any previous errors
            el.find('b.error').addClass('hidden');

            for (var i = 0; i < fields.length; i += 1) {
                var field = fields[i];

                if (!field.checkValidity()) {
                    var msg = readability.h5f.getFieldValidationMessage(field),
                        error = $(field).next();

                    error.text(msg).removeClass('hidden');

                    // Don't bother checking any more fields if there is an invalid
                    return;
                }
            }
        }
    },

    init: function () {
        var form = $('#read-later-login-form');

        if (form.length) {
            rdb.h5f.loadPolyfill(function () {
                if (!rdb.h5f.hasSupport()) {
                    H5F.setup(form.get(0));
                }
            });

            form.on('submit', this.formSubmit);
        }
    }
};

rdb.article.activator = {
    // This still in use but should be considered deprecated. Use the
    // Constraint validation api instead.
    validateEmail: function (email) {
        var pattern = new RegExp(/^[^@ ]+@[^@ ]+\.[^@ ]+$/i);
        return pattern.test(email);
    },

    activate: function (args) {
        var options = {
            "email": args.email,
            "success": args.success || function () {},
            "error": args.error || function () {},
            "complete": args.complete || function () {}
        };

        $.ajax({
            url: "/account/ajax/register",
            type: "POST",
            dataType: "json",
            data: {
                "email": options.email
            },
            success: function (responseObj) {
                if (responseObj.success) {
                    options.success(responseObj);
                }
                else {
                    options.error(responseObj);
                }
            },
            error: function (xhr, textStatus, errorThrown) {
                // Build a "fake" error object
                var errorObject = {"success": false, "errorCode": xhr.status, "error": textStatus};
                options.error(errorObject);
            },
            complete: function (jqXHR, textStatus) {
                options.complete(jqXHR, textStatus);
            }
        });
    }
};

// This is used on the login form for unathed users that attempt to Read Later
// from the Reading View.
rdb.article.handlePostMessage = (function(){
    var // All messages need to have an origin that matches the secure root domain
        // without a trailing slash.
        domain = rdb.utilities.secureBaseUrl.replace(/\/$/,''),
        // Map postMessage events to callables
        postMessageMap = {
            'login-success': function(event){
                // Just refresh the page to get the logged-in view
                document.location.href = document.location.href;
            },
            'login-failure': function(event){
                rdb.article.showLoginError($('#cdm-login'), 'Sorry, that login was incorrect. Please try again.');

                $.colorbox.resize();
            },
            'read-later-success': function(event){
                $.colorbox.close();
                rdb.article.readLater.readLater();
            },
            'read-later-failure': function(event){
                rdb.article.showLoginError($('#read-later-cdm-login'), 'Sorry, that login was incorrect. Please try again.');

                $.colorbox.resize();
            },
            'kindle_setup_success': function(event){
                console.log(event);
            }
        };

    // handlePostMessage public signature
    return function (event) {
        // jQuery doesn't pass us the actual event. The postMessage event will
        // be a property originalEvent of the event object passed. We use
        // jQuery to attach the event listener because the method is different
        // for IE
        var originalEvent = event.originalEvent || event;

        if (originalEvent.origin != domain) return;

        try {
            postMessageMap[originalEvent.data](originalEvent);
        }
        catch (postMessageError) {
            console.log('postMessage error for event ' + originalEvent.data);
        }
    };
}());

rdb.article.showLoginError = function ($form, error) {
    var info = $form.find('.form-msg:eq(0)'),
        problem = $form.find('.form-msg.problem');

    if (error) {
        info.addClass('hidden');
        problem.removeClass('hidden');

        problem.find('h3').html(error);
    }
    else {
        info.removeClass('hidden');
        problem.addClass('hidden');
    }
};

// Outside of the document.ready block below because it uses window.onload instead.
$(window).load(function () {
    if ($('body').data('print') === 1) {
        window.print();
    }
});

$(function () {

    _.mixin({
        oppositeVal: function (val) {
            return (val) ? 0 : 1;
        }
    });

    rdb.article.pageFetcher.init();
    rdb.article.direction.init();
    rdb.article.layoutImages.init();
    rdb.article.sidebar.init();
    rdb.article.smoothScrolling.init();
    rdb.article.readLater.init();
    rdb.article.login.init();

    $('a.article-print').on('click', function (e) {
        e.preventDefault();
        window.print();
    });

    // Listen for Cross Domain Messages from our iframes and other windows
    $(window).bind('message', rdb.article.handlePostMessage);

    $('a.share-email').on('click', function (e) {
        e.preventDefault();
        rdb.share.openEmailBox($('article.hentry').attr('data-article-id'));
    });

    $('a.share-twitter').on('click', function (e) {
        e.preventDefault();
        rdb.share.openTwitterBox($(this).data('url'), $(this).data('tweet'), $(this).data('counturl'));
    });

    $('.entry-content img').each(function () {
        if ($(this).width() === 0) {
            // If the image was not cached, call layoutImage when it's loaded.
            $(this).load(function () {
                rdb.article.layoutImages.layoutImage($(this));
            });

        } else {
            // If the image was cached, you call it immediately because onload will never fire.
            rdb.article.layoutImages.layoutImage($(this));
        }
    });

    // The question at the bottom of each article;
    // "Did this article display correctly"
    function parseReporting () {
        var container = $('div.parse-reporting');

        function makeRequest (options) {
            var settings = {
                type: 'POST',
                url: '/contact/parser/ajax/',
                data: {
                    'article_id': $('article.hentry').attr('data-article-id')
                }
            };

            $.extend(true, settings, options);
            $.ajax(settings);
        }

        // Submitting the optional feedback form
        function submitHandler (e) {
            e.preventDefault();

            var form = $(e.target),
                flyout = form.parent(),
                input = form.find('textarea'),
                msgEl = form.find('b.msg'),
                requestSettings = {},
                requestMsg = '';

            flyout.addClass('working');

            requestSettings.success = function (res) {
                if (res.success) {
                    flyout.removeClass('working')
                        .addClass('success');

                    // Close the flyout if they don't
                    if (flyout.is(':visible')) {
                        setTimeout(function () {
                            $('body').trigger('click.flyout');
                        }, 4500);
                    }
                }
                else {
                    requestSettings.error();
                }
            };

            requestSettings.error = function (xhr, httpstatus, error) {
                flyout.removeClass('working').addClass('trouble');

                setTimeout(function () {
                    flyout.removeClass('trouble');
                }, 2000);
            };

            $.each(form.find('input:checked'), function (val, elem) {
                var el = $(elem),
                    issueNum = el.val();

                if (issueNum !== '6') {
                    requestMsg += '[ISSUE-' + el.val() + '] - ' + el.parent().text().trim() + ' ';
                }
                else {
                    requestMsg += '[USER PROVIDED] ';
                }
            });

            if (input.val()) {
                requestMsg += input.val().trim();
            }

            if (requestMsg.length) {
                requestSettings.data = {
                    'message': requestMsg
                };
            }

            makeRequest(requestSettings);
        }

        function displayFeedbackForm (target) {
            var flyout = $('#flyout-parse-feedback'),
                other = $('p.other-details'),
                targetPos = target.offset();

            rdb.h5f.loadPolyfill();

            // We don't want the Other details textarea shown at first
            other.addClass('hidden');

            // Just in case it was submitting before (shouldn't happen)
            flyout.removeClass('success working');

            // Show/hide the more details textarea
            $('input.other-checkbox').on('change', function (e) {
                var el = $(e.target),
                    initHeight = flyout.height();

                if (el.is(':checked')) {
                    other.removeClass('hidden');
                }
                else {
                    other.addClass('hidden');
                }

                // TODO: Fix this 11th hour fix
                if (rdb.getScreenSize() !== 'small') {
                    var newTop = parseInt(flyout.css('top'), 10) + (initHeight - flyout.height());
                    flyout.css('top', newTop);
                }
            });

            // Maybe not the best way to do this but it'll work for now.
            // Generally setting CSS in JS is bad.
            if (rdb.getScreenSize() !== 'small') {
                flyout.css({
                    'position': 'absolute',
                    'top': targetPos.top - ((target.height() * 1.3) + flyout.height()),
                    'left': targetPos.left - flyout.width() * 0.5
                });
            }

            flyout.removeClass('hidden');

            flyout.find('.cancel').on('click', function () {
                $('body').trigger('click.flyout');
            });

            flyout.find('form').submit(submitHandler);
        }

        container.on('click', 'a', function (e) {
            e.preventDefault();

            var displayIsCorrect = parseInt($(e.target).attr('data-value'), 10);

            // If they're just letting us know everything was OK, we don't actually
            // want to make a request. That click does have a stat attached to
            // it so it helps us.
            if (displayIsCorrect) {
                container.addClass('working');
                setTimeout(function () {
                    container.removeClass('working')
                        .addClass('success');
                }, 800);
            }
            else {
                setTimeout(function () {
                    displayFeedbackForm($(e.target));
                }, 100);
            }
        });
    }

    parseReporting();

    // Favoriting and archiving are very similar. instead of writing nearly the
    // same function for both we can use this more general function.
    function initArticleEvent (settings) {
        $('body').on(settings.eventName, function () {
            var article = $('article.hentry'),
                newVal = _.oppositeVal(parseInt(article.attr(settings.dataAttr), 10));

            function updateDOM (val) {
                article.attr(settings.dataAttr, val);

                if (val) {
                    settings.el.addClass('active').attr('title', settings.titles.active);
                } else {
                    settings.el.removeClass('active').attr('title', settings.titles.inactive);
                }

                // I don't really like having to call out this action specifically, but I
                // think it will do for now.
                if (settings.eventName === 'archive') {
                    if (val) {
                        settings.el.removeClass('icon-archive').addClass('icon-unarchive');
                    }
                    else {
                        settings.el.removeClass('icon-unarchive').addClass('icon-archive');
                    }
                }
            }

            function makeRequest (val) {
                var reqSettings = {
                    type: 'POST',
                    url: settings.el.attr('href'),
                    dataType: 'json',
                    success: function (res) {
                        // Another edge case. If the request was unsuccessful,
                        // reset the DOM to before the event was triggered.
                        if (!res.success) {
                            updateDOM(_.oppositeVal(val));
                        }
                    },
                    error: function () {
                        // If this fails, revert the DOM back
                        updateDOM(_.oppositeVal(val));
                    }
                };

                if (settings.reqDataKey) {
                    reqSettings.data = {};
                    reqSettings.data[settings.reqDataKey] = val;
                }

                $.ajax(reqSettings);
            }

            updateDOM(newVal);
            makeRequest(newVal);
        });

        settings.el.on('click', function (e) {
            e.preventDefault();
            $('body').trigger(settings.eventName);
        });
    }

    initArticleEvent({
        eventName: 'favorite',
        dataAttr: 'data-is-favorite',
        titles: {
            'active': 'Remove from Favorites',
            'inactive': 'Mark as Favorite'
        },
        el: $('a.article-favorite')
    });

    initArticleEvent({
        eventName: 'archive',
        dataAttr: 'data-is-archived',
        titles: {
            'active': 'Unarchive this article',
            'inactive': 'Archive this article'
        },
        el: $('a.article-archive'),
        reqDataKey: 'value'
    });

    function articleDeletion () {
        var el = $('#flyout-delete-confirmation');

        function deleteFlyoutPreappend (e) {
            var target = $(e.target),
                flyout = $('div.flyout-delete-confirmation');

            function updateAttrs () {
                if (target.hasClass('actions-delete')) {
                    flyout.removeClass('tip-left')
                        .addClass('tip-bottom');
                }
                else {
                    flyout.removeClass('tip-bottom').addClass('tip-left');
                }
            }

            updateAttrs();
        }

        function deleteConfirmOpened (e, target, targetFlyout) {
            if (target.hasClass('actions-delete')) {
                var targetPos = target.offset();

                targetFlyout.css({
                    'position': 'absolute',
                    'top': targetPos.top - (target.height() + targetFlyout.height() * 0.9),
                    'left': targetPos.left - targetFlyout.width() * 0.5
                });
            }
        }

        el.on('click', 'button', function (e) {
            var answer = $(this).attr('data-answer');
            e.preventDefault();

            if (answer === 'yes') {
                $(this).parent().submit();
            }
            else {
                $('body').trigger('flyout.close');
            }
        });

        $('body').on('opened.flyout', deleteConfirmOpened);

        $('a.article-delete').on('click', deleteFlyoutPreappend);

        // Bind this for the keyboard shortcut
        $('body').on('delete', function () {
            $('.article-delete').trigger('click');
        });
    }

    articleDeletion();

    // TODO: I deliberatly repeated a good chunk of code here. This shares most
    // of the same functionality as the tagging and delete flyouts.
    function initShareExport () {

        function flyoutPreappend (e) {
            var target = $(e.target),
                flyout = $('div.flyout-share-export'),
                kindleFlyout = $('.flyout-kindle'),
                kindleBtn = flyout.find('a.article-to-kindle');

            if (target.hasClass('actions-share-export')) {
                kindleBtn.attr('data-flyout-target', '.article-share-export:first');
                kindleFlyout.removeClass('tip-left').addClass('tip-bottom');

                flyout.removeClass('tip-left').addClass('tip-bottom');
            }
            else {
                kindleBtn.attr('data-flyout-target', '.article-share-export:last');
                kindleFlyout.removeClass('tip-bottom').addClass('tip-left');

                flyout.removeClass('tip-bottom').addClass('tip-left');
            }
        }

        function flyoutOpened (e, target, targetFlyout) {
            if (target.hasClass('actions-share-export')) {
                var targetPos = target.offset();

                targetFlyout.css({
                    'position': 'absolute',
                    'top': targetPos.top - (target.height() + targetFlyout.height() * 0.9),
                    'left': targetPos.left - targetFlyout.width() * 0.5
                });
            }
        }

        $('body').on('opened.flyout', flyoutOpened);
        $('a.article-share-export').on('click', flyoutPreappend);
    }

    initShareExport();

    function keyboardShortcuts () {
        var shortcuts = {
                70: 'favorite',
                65: 'archive',
                84: 'tag',
                83: 'setAppearance',
                72: 'toggleSidebar', // h
                68: 'delete',
                79: 'originalPage',
                74: 'prev', // j
                75: 'next', // k
                191: 'map' // "?"
            },
            mapHtml = $('#keyboard-shortcuts-map').html();

        function prevOrNext (val) {
            return function () {
                var url = $('article.hentry').attr('data-' + val + '-article');

                if (url) {
                    window.location.href = url;
                }
            };
        }

        $('body').on({
            'map': function () {
                if ($('#colorbox').is(':visible')) {
                    $.colorbox.close();
                }
                else {
                    $.colorbox({
                        html: mapHtml
                    });
                }
            },
            'prev': prevOrNext('prev'),
            'next': prevOrNext('next'),
            'tag': function () {
                $('a.toolbar-tags:last').trigger('click');
            },
            'setAppearance': function () {
                $('a.article-appearance').trigger('click');
            },
            'originalPage': function () {
                window.location.href = $('a.original-page').attr('href');
            },
            'keyup.shortcuts': function (e) {
                if (!$(e.target).is('input, textarea')) {
                    if (shortcuts[e.keyCode]) {
                        $('body').trigger(shortcuts[e.keyCode]);
                    }
                }
            }
        });
    }

    // The shortcuts template el will only be in the DOM if they are enabled
    if ($('#keyboard-shortcuts-map').length) {
        keyboardShortcuts();
    }
});