
/*
 *
 *  (c) BU Web Advanced
 *
 *
*/



var container = document.getElementById("container");


var renderer = new THREE.WebGLRenderer({ antialias: true });
// var renderer = new THREE.CanvasRenderer();
renderer.setSize(container.offsetWidth, container.offsetHeight);
container.appendChild( renderer.domElement );


var scene = new THREE.Scene();


var camera = new THREE.PerspectiveCamera( 45, container.offsetWidth / container.offsetHeight, 1, 4000 );
camera.position.set( 0, 0, 3 );
scene.add( camera );


var light = new THREE.DirectionalLight( 0xffffff, 1.0);
light.position.set(0, 0, 10);
scene.add( light );



var mesh = new THREE.Mesh();

var map = THREE.ImageUtils.loadTexture("models/texture.png");
var material = new THREE.MeshPhongMaterial({ map: map });


material.side = THREE.DoubleSide;

loader = new THREE.JSONLoader();
loader.load("models/model.js", onLoadComplete)



function onLoadComplete(geometry)
{
  mesh = new THREE.Mesh(geometry, material);
  mesh.position.x = 4;
  scene.add(mesh);
  renderer.render(scene, camera);
}








function changeCamera(posX, posY, posZ, rotX, rotY, rotZ) {
  $({
    poxX: mesh.position.x,
    poxY: mesh.position.y,
    poxZ: mesh.position.z,
    rotX: mesh.rotation.x,
    rotY: mesh.rotation.y,
    rotZ: mesh.rotation.z
  }).animate({
    posX: posX,
    posY: posY,
    posZ: posZ,
    rotX: rotX,
    rotY: rotY,
    rotZ: rotZ
  },{
      duration: 500,
      step: function(){
        mesh.position.x = this.posX;
        mesh.position.y = this.posY;
        mesh.position.z = this.posZ;
        mesh.rotation.x = this.rotX;
        mesh.rotation.y = this.rotY;
        mesh.rotation.z = this.rotZ;
    }
  })
}



window.onresize = function() {

  $("canvas")[0].width = container.offsetWidth;
  $("canvas")[0].height = container.offsetHeight;
  
  renderer.setSize(container.offsetWidth, container.offsetHeight);
  camera.aspect = container.offsetWidth / container.offsetHeight;
  camera.updateProjectionMatrix();
}






function loop()
{
  renderer.render(scene, camera);
  requestAnimationFrame( loop );
}

loop();















/********** debug camera navigation ***********/


$(window).keyup(function(e){
    console.log(e.keyCode)

    // x- und y-Achse (Pfeiltasten)
    if(e.keyCode == 39)
    {
      mesh.position.x -= .1;
    }
    else if(e.keyCode == 37)
    {
      mesh.position.x += .1;
    }
    else if(e.keyCode == 38)
    {
      mesh.position.y -= .1;
    }
    else if(e.keyCode == 40)
    {
      mesh.position.y += .1;
    }

    // z-Achse (Z und U)
    else if(e.keyCode == 90)
    {
      mesh.position.z += .1;
    }
    else if(e.keyCode == 85)
    {
      mesh.position.z -= .1;
    }

    // Rotation x- und z-Achse (WASD)
    else if(e.keyCode == 87)
    {
      mesh.rotation.x -= .1;
    }
    else if(e.keyCode == 83)
    {
      mesh.rotation.x += .1;
    }
    else if(e.keyCode == 65)
    {
      mesh.rotation.z += .1;
    }
    else if(e.keyCode == 68)
    {
      mesh.rotation.z -= .1;
    }
})















/*

###### SNIPPETS ###########








// jquery Variable Counter
$({meineVar:1}).animate({meineVar:0},{
  step: function(){
  }
})



MeshLambertMaterial



2,.6,2.5

*/