﻿<?php
class Validator {
	public static function makeSecure( $string, $default="" ) {
		if( empty( $string ) ) {
			return $default;
			
		} else {
			$string = strip_tags( trim( ( $string ) ) );
			$string = escapeshellcmd( $string );
			return stripslashes( $string );
			
		}
	}

	public static function validateEmail( $mail, $default="" ) {
		$smail = self::makeSecure( $mail, $default );
		
		$pattern = "/^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/";
		$matches = array();
		
		preg_match($pattern, $smail, $matches );
		
		if	( count( $matches ) == 0 ) {
			return $default;
			
		} else {
			return $smail;
			
		}
	}
}
?>