/*
 * Decompiled with CFR 0.152.
 */
package search.eightpuzzle;

import java.util.ArrayList;
import java.util.Iterator;

public class PuzzleState
implements Iterable<PuzzleState> {
    private final byte[][] tiles;
    private final byte[] rowOf;
    private final byte[] columnOf;
    private final int code;
    private final PuzzleState parent;

    public PuzzleState(int tile00, int tile01, int tile02, int tile10, int tile11, int tile12, int tile20, int tile21, int tile22) {
        boolean[] contained = new boolean[9];
        contained[tile00] = true;
        contained[tile01] = true;
        contained[tile02] = true;
        contained[tile10] = true;
        contained[tile11] = true;
        contained[tile12] = true;
        contained[tile20] = true;
        contained[tile21] = true;
        contained[tile22] = true;
        int i = 0;
        while (i < 9) {
            assert (contained[i]);
            ++i;
        }
        this.tiles = new byte[3][3];
        this.tiles[0][0] = (byte)tile00;
        this.tiles[0][1] = (byte)tile01;
        this.tiles[0][2] = (byte)tile02;
        this.tiles[1][0] = (byte)tile10;
        this.tiles[1][1] = (byte)tile11;
        this.tiles[1][2] = (byte)tile12;
        this.tiles[2][0] = (byte)tile20;
        this.tiles[2][1] = (byte)tile21;
        this.tiles[2][2] = (byte)tile22;
        this.rowOf = new byte[9];
        this.columnOf = new byte[9];
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.rowOf[this.tiles[i][j]] = (byte)i;
                this.columnOf[this.tiles[i][j]] = (byte)j;
                ++j;
            }
            ++i;
        }
        this.code = this.calcHashCode();
        this.parent = null;
    }

    public PuzzleState(PuzzleState parent, int emptyTileRow, int emptyTileColumn, int selectedTileRow, int selectedTileColumn) {
        assert (parent.tiles[emptyTileRow][emptyTileColumn] == 0);
        int rowChange = (emptyTileRow - selectedTileRow) * (emptyTileRow - selectedTileRow);
        int columnChange = (emptyTileColumn - selectedTileColumn) * (emptyTileColumn - selectedTileColumn);
        assert (rowChange == 0 && columnChange == 1 || rowChange == 1 && columnChange == 0);
        this.tiles = new byte[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.tiles[i][j] = parent.tiles[i][j];
                ++j;
            }
            ++i;
        }
        this.rowOf = new byte[9];
        this.columnOf = new byte[9];
        byte movedTile = this.tiles[selectedTileRow][selectedTileColumn];
        this.tiles[emptyTileRow][emptyTileColumn] = this.tiles[selectedTileRow][selectedTileColumn];
        this.tiles[selectedTileRow][selectedTileColumn] = 0;
        this.rowOf[movedTile] = (byte)emptyTileRow;
        this.columnOf[movedTile] = (byte)emptyTileColumn;
        this.rowOf[0] = (byte)selectedTileRow;
        this.columnOf[0] = (byte)selectedTileColumn;
        this.code = this.calcHashCode();
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public PuzzleState getParent() {
        return this.parent;
    }

    public int get(int row, int column) {
        return this.tiles[row][column];
    }

    public int getRowOf(int tile) {
        return this.rowOf[tile];
    }

    public int getColumnOf(int tile) {
        return this.columnOf[tile];
    }

    @Override
    public Iterator<PuzzleState> iterator() {
        byte emptyTileRow = this.rowOf[0];
        byte emptyTileColumn = this.columnOf[0];
        ArrayList<PuzzleState> children = new ArrayList<PuzzleState>(4);
        if (emptyTileRow > 0) {
            children.add(new PuzzleState(this, emptyTileRow, emptyTileColumn, emptyTileRow - 1, emptyTileColumn));
        }
        if (emptyTileRow < 2) {
            children.add(new PuzzleState(this, emptyTileRow, emptyTileColumn, emptyTileRow + 1, emptyTileColumn));
        }
        if (emptyTileColumn > 0) {
            children.add(new PuzzleState(this, emptyTileRow, emptyTileColumn, emptyTileRow, emptyTileColumn - 1));
        }
        if (emptyTileColumn < 2) {
            children.add(new PuzzleState(this, emptyTileRow, emptyTileColumn, emptyTileRow, emptyTileColumn + 1));
        }
        return children.iterator();
    }

    public int hashCode() {
        return this.code;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof PuzzleState) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(12);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                builder.append(this.tiles[i][j]);
                ++j;
            }
            if (i < 2) {
                builder.append('/');
            }
            ++i;
        }
        return builder.toString();
    }

    public String printHistory() {
        if (this.hasParent()) {
            StringBuilder history = new StringBuilder();
            history.append(this.parent.printHistory());
            history.append('\n');
            history.append(this.toString());
            return history.toString();
        }
        return this.toString();
    }

    public int getDepth() {
        if (this.hasParent()) {
            return this.parent.getDepth() + 1;
        }
        return 0;
    }

    private int calcHashCode() {
        int code = 0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                code *= 10;
                code += this.tiles[i][j];
                ++j;
            }
            ++i;
        }
        return code;
    }
}

