/*
 * Decompiled with CFR 0.152.
 */
package search.eightpuzzle;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import search.eightpuzzle.Heuristic;
import search.eightpuzzle.ManhattanHeuristic;
import search.eightpuzzle.MismatchHeuristic;
import search.eightpuzzle.PuzzleState;
import search.eightpuzzle.ZeroHeuristic;

public class AStar {
    private final PuzzleState goal;
    private final Heuristic heuristic;
    private final PriorityQueue<WeightedState> open;
    private final Map<Integer, Integer> minCosts;

    public AStar(PuzzleState start, PuzzleState goal, Heuristic heuristic) {
        assert (start != null);
        assert (goal != null);
        assert (heuristic != null);
        this.goal = goal;
        this.heuristic = heuristic;
        this.open = new PriorityQueue();
        this.open.add(new WeightedState(0, start));
        this.minCosts = new HashMap<Integer, Integer>();
        this.minCosts.put(start.hashCode(), 0);
    }

    private PuzzleState search() {
        PuzzleState state = null;
        int counter = 0;
        while (state == null) {
            ++counter;
            try {
                state = this.advance();
            }
            catch (NoSuchElementException e) {
                System.out.println("Aborted after " + counter + " steps");
                return null;
            }
        }
        System.out.println("Found goal after " + counter + " steps");
        return state;
    }

    private PuzzleState advance() {
        WeightedState n = this.nextStateFromOpen();
        if (n == null) {
            throw new NoSuchElementException();
        }
        if (n.state.equals(this.goal)) {
            return n.state;
        }
        for (PuzzleState successor : n.state) {
            int newCost = n.currentCost + 1;
            Integer oldCost = this.minCosts.get(successor.hashCode());
            if (oldCost != null && newCost >= oldCost) continue;
            this.open.add(new WeightedState(newCost, successor));
            this.minCosts.put(successor.hashCode(), newCost);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private WeightedState nextStateFromOpen() {
        n = this.open.poll();
        if (n != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            n = this.open.poll();
            if (n != null) continue;
            return null;
lbl7:
            // 2 sources

            ** while (WeightedState.access$3((WeightedState)n) > this.minCosts.get((Object)Integer.valueOf((int)WeightedState.access$2((WeightedState)n).hashCode())).intValue())
        }
lbl8:
        // 1 sources

        return n;
    }

    private static void run(PuzzleState start, PuzzleState goal, Heuristic heuristic) {
        System.out.println();
        AStar search = new AStar(start, goal, heuristic);
        System.out.println("Start " + start + " with heuristic " + heuristic);
        PuzzleState found = search.search();
        if (found != null) {
            System.out.println(found.printHistory());
            System.out.println("Goal " + goal + " reached in " + found.getDepth() + " moves.");
        } else {
            System.out.println("Goal " + goal + " not reached ");
        }
    }

    public static void main(String[] args) {
        PuzzleState start = new PuzzleState(6, 4, 7, 8, 5, 0, 3, 2, 1);
        PuzzleState goal = new PuzzleState(1, 2, 3, 4, 5, 6, 7, 8, 0);
        AStar.run(start, goal, new ZeroHeuristic());
        AStar.run(start, goal, new MismatchHeuristic());
        AStar.run(start, goal, new ManhattanHeuristic());
    }

    private class WeightedState
    implements Comparable<WeightedState> {
        private final int currentCost;
        private final int estimatedCost;
        private final PuzzleState state;

        private WeightedState(int currentCost, PuzzleState state) {
            assert (state != null);
            this.currentCost = currentCost;
            this.state = state;
            this.estimatedCost = this.currentCost + AStar.this.heuristic.estimate(this.state, AStar.this.goal);
        }

        @Override
        public int compareTo(WeightedState o) {
            int weightDifference = this.estimatedCost - o.estimatedCost;
            return weightDifference;
        }
    }
}

