import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jaxb.Feed;

public class FeedServlet extends HttpServlet {

    public static FeedModel model = new FeedModel();

    /**
     * For reference, see the HTTP/1.1 specification section about GET
     * https://tools.ietf.org/html/rfc7231#section-4.3.1
     *
     * @param request Client request
     * @param response Server response
     * @throws ServletException
     * @throws IOException
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        // Specify response header fields
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xml");
        response.setStatus(HttpServletResponse.SC_OK);

        // Retrieve writer object of the response
        PrintWriter responseWriter = response.getWriter();
        model.serializeFeed(responseWriter);
    }

    /**
     * For reference, see the HTTP/1.1 specification section about POST
     * https://tools.ietf.org/html/rfc7231#section-4.3.3
     *
     * @param request Client request
     * @param response Server response
     * @throws ServletException
     * @throws IOException
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        // Retrieve the parameters that were submitted through the form
        String title = request.getParameter("title");
        String url = request.getParameter("url");
        String author = request.getParameter("author");
        String summary = request.getParameter("summary");
        model.addEntry(title, url, summary, author);

        // Respond to the request indirectly by setting the status code 303.
        // 303 (See Other) indicates a redirect to the URI specified in the
        // `Location` header field.
        response.setStatus(HttpServletResponse.SC_SEE_OTHER);

        // The specification requires to set the location header to the
        // identifier of the created resource after a successful POST request
        // was made. Due to a missing `getEntry` method in the Java API, we can
        // only use the path of the collection resource instead.
        response.setHeader("Location", "Feed");
    }
}
