package observer;

import java.util.List;
import java.util.ArrayList;

public class Subject {
    private List<Observer> observers = new ArrayList<>();
    private int value;

    public Subject() {
    }

    public void setValue(int value) {
        this.value = value;
        notifyObservers();
    }

    public void notifyObservers() {
        for (Observer observer : observers) {
            observer.update(this.value);
        }
    }

    public void addObserver(Observer observer) {
        observers.add(observer);
    }
}
