package observer;

public class DivObserver extends Observer {
    private int divisor;

    public DivObserver(Subject subject, int divisor) {
        this.divisor = divisor;
        this.subject = subject;
        subject.addObserver(this);
    }

    public void update(int value) {
        System.out.println(value + " div " + this.divisor + " = " + value / divisor);
    }
}
