package exercise;

import static org.junit.jupiter.api.Assertions.fail;

import static org.junit.jupiter.api.Assertions.assertAll;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.junit.jupiter.api.Assumptions.assumeTrue;
import static org.junit.jupiter.api.Assumptions.assumingThat;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import java.time.LocalDateTime;

public class AppTest {

    // Create a fixture for the class under test
    private App classUnderTest;

    // Do something before any test is run in this class
    @BeforeAll
    public static void init() {
        System.out.println("Initialize");
    }

    // Do something after all tests in this class are run
    @AfterAll
    public static void done() {
        System.out.println("Done!");
    }

    // Create an instance of the test class before each @Test method is executed
    @BeforeEach
    public void setUp() throws Exception {
        System.out.println("@BeforeEach: setUp()");
        classUnderTest = new App();
    }

    // Destroy reference to the instance of the test class after each @Test method is executed
    @AfterEach
    public void tearDown() throws Exception {
        System.out.println("@AfterEach: tearDown()");
        classUnderTest = null;
    }

    // Disabled test
    @Test
    @Disabled
    void testNotRun() {
        System.out.println("This will never show up.");
    }

    @Test
    @DisplayName("When numbers are > 0")
    public void testAddPositiveNumbers() {
        assertNotNull(classUnderTest);
        assertAll(
                () -> {
                    //
                    // Test #1
                    long[] numbersToSum = { 1, 2, 3, 4 };
                    long expectedSum = 10;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    //
                    // Test #2
                    long[] numbersToSum = new long[] { 20, 934, 110 };
                    long expectedSum = 1064;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    //
                    // Test #3
                    long[] numbersToSum = new long[] { 2, 4, 6 };
                    long expectedSum = 12;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                });
    }

    @Test
    @DisplayName("Tests with numbers < 0")
    public void testAddNegativeNumbers() {
        assertNotNull(classUnderTest);
        assertAll(
                () -> {
                    //
                    // Test #1
                    long[] numbersToSum = { -1, -2, -3, -4 };
                    long expectedSum = -10;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    //
                    // Test #2
                    long[] numbersToSum = { -20, -934, -110 };
                    long expectedSum = -1064;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    //
                    // Test #3
                    long[] numbersToSum = new long[] { -2, -4, -6 };
                    long expectedSum = -12;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                });
    }

    @Test
    @DisplayName("Test with numbers > 0 and < 0")
    public void testAddPositiveAndNegativeNumbers() {
        assertNotNull(classUnderTest);
        assertAll(
                () -> {
                    //
                    // Test #1
                    long[] numbersToSum = { -1, 2, -3, 4 };
                    long expectedSum = 2;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    //
                    // Test #2
                    long[] numbersToSum = { -20, 934, -110 };
                    long expectedSum = 804;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    //
                    // Test #3
                    long[] numbersToSum = new long[] { -2, -4, 6 };
                    long expectedSum = 0;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                });
    }

    @Test
    @DisplayName("This test is only run on Fridays")
    public void testAddOnlyOnFriday() {
        LocalDateTime ldt = LocalDateTime.now();
        assumeTrue(ldt.getDayOfWeek().getValue() == 5, "Test skipped... it's not Friday!");
        long[] operands = { 1, 2, 3, 4, 5 };
        long expectedSum = 15;
        long actualSum = classUnderTest.add(operands);
        assertEquals(expectedSum, actualSum);
    }

    public void testAddSinglePositiveOperand() {
        assertNotNull(classUnderTest);
        assertAll(
                () -> {
                    long[] numbersToSum = { 1 };
                    long expectedSum = 1;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    long[] numbersToSum = { 0 };
                    long expectedSum = 0;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                });
    }

    public void testAddSingleNegativeOperand() {
        assertNotNull(classUnderTest);
        assertAll(
                () -> {
                    long[] numbersToSum = { -1 };
                    long expectedSum = -1;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                },
                () -> {
                    long[] numbersToSum = { -10 };
                    long expectedSum = -10;
                    long actualSum = classUnderTest.add(numbersToSum);
                    assertEquals(expectedSum, actualSum);
                });
    }

    @Test()
    @DisplayName("Empty argument")
    public void testAdd_ZeroOperands_EmptyArgument() {
        assertNotNull(classUnderTest);
        long[] numbersToSum = {};
        assertThrows(IllegalArgumentException.class, () -> classUnderTest.add(numbersToSum));
    }
}
