package exercise;

public class App {
  /**
   * Computes the sum of the specified operands.
   *
   * @throws IllegalArgumentException If the specified array of operands is empty.
   */
  public long add(long[] operands) {
    long sum = 0;
    if (operands.length == 0) {
      throw new IllegalArgumentException("Operands argument cannot be empty");
    }
    for (long operand : operands) {
      sum += operand;
    }
    return sum;
  }
}
