public class Main {

    public static void main(String[] args) {
        Deque<Integer> deque = new ArrayListToDequeAdapter<>();

        deque.push(1);
        deque.push(2);
        deque.push(3);
        deque.push(4);

        System.out.print("Created deque: ");
        deque.print();

        System.out.println("First element: " + deque.first());
        System.out.println("Last element: " + deque.last());

        System.out.println("deque.put(0)");
        deque.put(0);
        deque.print();

        System.out.println("Popped element: " + deque.pop());
        System.out.println("Got element: " + deque.get());
        deque.print();

        System.out.println("deque.pop()");
        deque.pop();
        System.out.println("deque.pop()");
        deque.pop();
        deque.print();

        System.out.println("deque.pop()");
        deque.pop();
        deque.print();

        // now deque is empty, so each pop or get should raise an exception
        try {
            deque.pop();
        } catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Catched ArrayIndexOutOfBoundException");
        }
        try {
            deque.get();
        } catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Catched ArrayIndexOutOfBoundException");
        }
    }
}
