import java.util.ArrayList;
import java.util.List;

class ArrayListToDequeAdapter<T> implements Deque<T> {
    private List<T> list = new ArrayList<T>();

    @Override
    public void push(T element) {
        list.add(element);
    }

    @Override
    public T pop() {
        T element = last();
        list.remove(list.size() - 1);

        return element;
    }

    @Override
    public void put(T element) {
        List<T> tmpList = new ArrayList<T>();
        tmpList.add(element);
        tmpList.addAll(list);
        list = tmpList;
    }

    @Override
    public T get() {
        T element = first();
        list = list.subList(1, list.size());

        return element;
    }

    @Override
    public T first() {
        if (list.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Deque is empty!");
        }
        return list.get(0);
    }

    @Override
    public T last() {
        if (list.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException("Deque is empty!");
        }
        return list.get(list.size() - 1);
    }

    @Override
    public void print() {
        if (list.isEmpty()) {
            System.out.println("<EMPTY>");
        } else {
            StringBuilder sb = new StringBuilder();
            for (T element : list) {
                sb.append(element);
                sb.append(" ");
            }
            sb.deleteCharAt(sb.lastIndexOf(" "));

            System.out.println(sb.toString());
        }
    }
}
