public class ShapeFactory {
    private static ShapeFactory instance = new ShapeFactory();

    // Private constructor for singleton pattern
    private ShapeFactory() {
    }

    public static ShapeFactory getInstance() {
        return instance;
    }

    public Shape getShape(String shapeName) throws ShapeNotFoundException {
        switch (shapeName.toLowerCase()) {
            case "circle": return new Circle();
            case "square": return new Square();
            case "rectangle": return new Rectangle();
            default: throw new ShapeNotFoundException(shapeName.toLowerCase());
        }
    }
}
