import java.util.ArrayList;
import java.util.List;

public class FactoryPatternDemo {

    public static void main(String[] args) {
        List<Shape> objectList = new ArrayList<>();

        ShapeFactory factory = ShapeFactory.getInstance();

        try {
            objectList.add(factory.getShape("circle"));
            objectList.add(factory.getShape("rectangle"));
            objectList.add(factory.getShape("square"));
            objectList.add(factory.getShape("oval"));
        } catch (ShapeNotFoundException shapeNotFoundException) {
            shapeNotFoundException.printStackTrace();
        }

        objectList.forEach(Shape::draw);

        ShapeFactory secondFactory = ShapeFactory.getInstance();
        System.out.println("Are both factories the same: " + factory.equals(secondFactory));
    }
}
