class AutorApp {
    public static void main(String[] args) {
        Autor max = new Autor(); // aufruf Standardkonstruktor

        //aufruf überladener Konstruktor
        Autor shakespeare = new Autor("William",
                                      "Shakespeare",
                                      "26.04.1564",
                                      "shakespeare.com",
                                      "Werke: Romeo und Julia, usw.");
        //aufruf überladener Konstruktor
        Autor goethe = new Autor("Johann Wolfgang",
                                 "von Goethe",
                                 "28.08.1749",
                                 "goethe.de",
                                 "Werke: Faust, der Erlkönig");
        //aufruf der public methode auf dem objekt max
        max.printInformation();
        System.out.println();
        //aufruf der public methode auf dem objekt shakespeare
        shakespeare.printInformation();
        System.out.println();
        //aufruf der public methode auf dem objekt goethe
        goethe.printInformation();

        //goethe.privateMethode();
    }
}

class Autor {
    //Memberattribute - private - nur innerhalb von Autor sichtbar!
    private String name;
    private String nachname;
    private String geboren;
    private String webseite;
    private String notiz;

    //Defaultkonstruktor
    public Autor() {
        this.name = "Max";
        this.nachname = "Mustermann";
        this.geboren = "01.01.1900";
        this.webseite = "example.com";
        this.notiz = "emptyNote";
    }

    //überladender Konstruktor
    public Autor(String name,
                 String nachname,
                 String geboren,
                 String webseite,
                 String notiz) {
        this.name = name;
        this.nachname = nachname;
        this.geboren = geboren;
        this.webseite = webseite;
        this.notiz = notiz;
    }

    //private Methode - nur innerhalb von Autor sichtbar!
    private void privateMethode() {
        System.out.println("das ist private!");
    }

    //public Methode - von jeder anderen Klasse aus sichtbar!
    public void printInformation() {
        System.out.println("Name: " + this.name + " " + this.nachname);
        System.out.println("geboren: " + this.geboren);
        System.out.println("webseite: " + this.webseite);
        System.out.println("notiz: " + this.notiz);
    }
}