/**
    Author: André Karge
 */
public class Queue {
    private Node left;
    private Node right;
    private int count;

    public Queue() {
        this.left = null;
        this.right = null;
        this.count = 0;
    }
    public void enqueue(Node n) {
        if(this.count == 0) {
            this.left = n;
            this.right = n;
            this.count++;
        }
        else {
            n.setNext(this.left);
            this.left = n;
            this.count++;
        }
    }
    public Node dequeue() {
        // wenn wir mehr als ein Element haben
        if(this.count > 1) {
            // hole das Vorgängerelement von dem, was am weitesten Rechts ist
            Node n = this.left;
            while(n.getNext() != this.right) {
                n = n.getNext();
            }
            // hole das letzte
            Node result = this.right;
            // setze diesen Zeiger
            n.setNext(null);
            this.right = n;
            this.count--;
            return result;
        }
        // wenn wir nur noch ein Element haben
        else if(this.count == 1) {
            Node result = this.right;
            this.left = null;
            this.right = null;
            this.count = 0;
            return result;
        }
        // wenn queue leer ist
        else {
            System.out.println("Queue is empty");
            return null;
        }
    }
}
