/**
    Author: André Karge
 */
public class List {
    private Node first;
    private Node last;
    private int count;

    public List() {
        this.first = null;
        this.last = null;
        this.count = 0;
    }
    public void add(Node n) {
        // wenn kein Element in der Liste: neues Element = first und last
        if(this.count == 0) {
            this.first = n;
            this.last = n;
            this.count++;
        }
        else {
            this.last.setNext(n); // setze beim vorherigen letzten Element die next Referenz auf das übergebene Objekt
            this.last = n; // setze die Referenz des letzten Listenelement
            this.count++;
        }
    }
    public void add(Node n, int index) {
        // wenn index höher als Anzahl Elemente oder kleiner 0
        if(index > this.count-1 || index < 0) {
            System.out.println("Falscher Index");
            return;
        }
        // laufe durch die Elemente bis wir den Index gefunden haben
        int j = 0;
        Node current = this.first;
        Node previous = null;
        while (j < index) {
            previous = current;
            current = current.getNext();
            j++;
        }

        // wenn wir am Anfang einfügen wollen
        if(this.count == 0) {
            // nutze die standard add Funktion
            add(n);
        }
        else {
            //setze Referenz vom übergebenen Element
            n.setNext(current);
            this.count++;
            if(previous == null) {
                this.first = n;
            }
            else {
                previous.setNext(n);
            }
        }
    }
    public void addBeginning(Node n) {
        add(n, 0);
    }
    public void printList() {
        Node tmp = this.first;
        // solange, bis wir am Ende sind
        while(tmp != null) {
            System.out.println(tmp.getData());
            tmp = tmp.getNext();
        }
    }

    public Node get(int index) {
        if(index > this.count-1) {
            System.out.println("Falscher Index");
            return null;
        }
        Node tmp = this.first;
        int i = 0;
        while(i < index) {
            tmp = tmp.getNext();
            i++;
        }
        return tmp;
    }
}