/*
 * Decompiled with CFR 0.152.
 */
package de.bauhaus_universitaet_weimar.medien.alg_eng.demo.vc;

import de.bauhaus_universitaet_weimar.medien.alg_eng.demo.vc.TheLettersAM;
import de.bauhaus_universitaet_weimar.medien.alg_eng.demo.vc.TheLettersNZ;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Random;
import javax.swing.JComponent;

class Folien
extends JComponent {
    protected static byte[][] Letters;
    protected boolean[][] folie;
    protected boolean[][] papier;
    protected boolean[][] nachricht;
    protected boolean[][] logonachricht;
    protected int ysize;
    protected int xsize;
    protected int pos = 0;
    protected int scale = 2;
    protected boolean messageVisible;
    protected int dragStartY;

    public Folien() {
        this(410, 140);
    }

    public Folien(int xsize, int ysize) {
        this.xsize = xsize / 2 * 2;
        this.ysize = ysize / 2 * 2;
        this.folie = new boolean[this.xsize][];
        this.papier = new boolean[this.xsize][];
        int i = 0;
        while (i < this.xsize) {
            this.folie[i] = new boolean[this.ysize];
            this.papier[i] = new boolean[this.ysize];
            ++i;
        }
        Letters = new byte[27][];
        i = 0;
        while (i < 13) {
            Folien.Letters[i] = TheLettersAM.Letters[i];
            Folien.Letters[14 + i] = TheLettersNZ.Letters[i];
            ++i;
        }
        Folien.Letters[13] = TheLettersAM.Letters[13];
        this.nachricht = new boolean[this.xsize / 2][];
        i = 0;
        while (i < this.xsize / 2) {
            this.nachricht[i] = new boolean[this.ysize / 2];
            ++i;
        }
        this.logonachricht = new boolean[this.xsize / 2][];
        i = 0;
        while (i < this.xsize / 2) {
            this.logonachricht[i] = new boolean[this.ysize / 2];
            ++i;
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Folien.this.dragStartY = e.getY() - Folien.this.pos;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Folien.this.setPosition(e.getY() - Folien.this.dragStartY);
            }
        });
        this.setPreferredSize(new Dimension(this.xsize * this.scale, 2 * this.ysize * this.scale + 30));
        this.setMinimumSize(new Dimension(this.xsize * this.scale, 2 * this.ysize * this.scale + 30));
    }

    public void randomize() {
        Random r = new Random();
        int x = 0;
        while (x < this.xsize) {
            int y = 0;
            while (y < this.ysize) {
                int zuf = r.nextInt() % 2;
                boolean bl = zuf == 0;
                this.papier[x][y + 1] = bl;
                this.folie[x][y + 1] = bl;
                this.papier[x][y] = bl;
                this.folie[x][y] = bl;
                boolean bl2 = zuf != 0;
                this.papier[x + 1][y + 1] = bl2;
                this.folie[x + 1][y + 1] = bl2;
                this.papier[x + 1][y] = bl2;
                this.folie[x + 1][y] = bl2;
                y += 2;
            }
            x += 2;
        }
        this.encodeMessage();
        this.repaint();
    }

    public void setPosition(int p) {
        this.pos = Math.max(0, p);
        this.pos = Math.min(30 + this.scale * this.ysize, this.pos);
        this.repaint();
    }

    private void encodeMessage() {
        int x = 0;
        while (x < this.xsize / 2) {
            int y = 0;
            while (y < this.ysize / 2) {
                if (this.nachricht[x][y]) {
                    this.papier[2 * x][2 * y] = !this.folie[2 * x][2 * y];
                    this.papier[2 * x + 1][2 * y] = !this.folie[2 * x + 1][2 * y];
                    this.papier[2 * x][2 * y + 1] = !this.folie[2 * x][2 * y + 1];
                    this.papier[2 * x + 1][2 * y + 1] = !this.folie[2 * x + 1][2 * y + 1];
                } else {
                    this.papier[2 * x][2 * y] = this.folie[2 * x][2 * y];
                    this.papier[2 * x + 1][2 * y] = this.folie[2 * x + 1][2 * y];
                    this.papier[2 * x][2 * y + 1] = this.folie[2 * x][2 * y + 1];
                    this.papier[2 * x + 1][2 * y + 1] = this.folie[2 * x + 1][2 * y + 1];
                }
                ++y;
            }
            ++x;
        }
    }

    public void setMessage(String message) {
        int col = 0;
        int row = 0;
        int maxy = 34;
        int c = 0;
        while (c < this.xsize / 2) {
            int r = 0;
            while (r < this.ysize / 2) {
                this.nachricht[c][r] = false;
                ++r;
            }
            ++c;
        }
        byte[] mess = message.toUpperCase().getBytes();
        int i = 0;
        while (i < mess.length) {
            byte[] let = mess[i] < 65 || mess[i] > 90 ? Letters[0] : Letters[mess[i] - 64];
            int wi = let[0];
            int hi = let[1];
            if (col + wi >= this.xsize / 2) {
                col = 0;
                if ((row += maxy) + maxy >= this.ysize / 2) break;
            }
            int w = 0;
            while (w < wi) {
                int h = 0;
                while (h < hi) {
                    this.nachricht[col + w][row + h] = let[2 + w * hi + h] == 1;
                    ++h;
                }
                ++w;
            }
            col += wi;
            ++i;
        }
        this.encodeMessage();
        this.repaint();
    }

    public void setMessageVisible(boolean b) {
        this.messageVisible = b;
        this.repaint();
    }

    public void setLogo(String message) {
        int col = 0;
        int row = 0;
        int maxy = 34;
        int c = 0;
        while (c < this.xsize / 2) {
            int r = 0;
            while (r < this.ysize / 2) {
                this.logonachricht[c][r] = false;
                ++r;
            }
            ++c;
        }
        byte[] mess = message.toUpperCase().getBytes();
        int i = 0;
        while (i < mess.length) {
            byte[] let = mess[i] < 65 || mess[i] > 90 ? Letters[0] : Letters[mess[i] - 64];
            int wi = let[0];
            int hi = let[1];
            if (col + wi >= this.xsize / 2) {
                col = 0;
                if ((row += maxy) + maxy >= this.ysize / 2) break;
            }
            int w = 0;
            while (w < wi) {
                int h = 0;
                while (h < hi) {
                    this.logonachricht[col + w][row + h] = let[2 + w * hi + h] == 1;
                    ++h;
                }
                ++w;
            }
            col += wi;
            ++i;
        }
        this.encodeMessage();
        this.repaint();
    }

    private Color getColor(int x, int y) {
        int hx = x - this.xsize / 2;
        int hy = y - this.ysize / 2;
        if (this.logonachricht[x / 2][y / 2]) {
            return new Color(0, 0, 255, 160);
        }
        return new Color(0, 0, 135);
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int x = 0;
        while (x < this.xsize) {
            y = 0;
            while (y < this.ysize) {
                if (this.papier[x][y]) {
                    if (this.messageVisible && this.nachricht[x / 2][y / 2]) {
                        g.setColor(Color.red);
                    } else {
                        g.setColor(Color.black);
                    }
                } else {
                    g.setColor(Color.white);
                }
                g.fillRect(x * this.scale, y * this.scale + this.scale * this.ysize + 30, this.scale, this.scale);
                if (this.folie[x][y]) {
                    g.setColor(this.getColor(x, y));
                    g.fillRect(x * this.scale, y * this.scale + this.pos, this.scale, this.scale);
                }
                ++y;
            }
            ++x;
        }
        if (this.messageVisible) {
            x = 0;
            while (x < this.xsize / 2) {
                y = 0;
                while (y < this.ysize / 2) {
                    ++y;
                }
                ++x;
            }
        }
    }
}

