%% tipDisplacement script
% Input are stored in variable Minput, outputs are saved in Moutput
% The order of variables in the columns in Minput and Moutput correspond to
% the order of names specified in the constructor of Mio.
%
% Access: CinputNames = {'u', 'v', 'x', 'y'}
%         Minput(i,3) : i-th sample of input variable x

I = Minput(:,1);
b = Minput(:,2); 
L = Minput(:,3); 
h = Minput(:,4); 
rho = Minput(:,5); 
P = Minput(:,6); 
E = Minput(:,7);

Moutput = ...
    (rho*9.81.*b.*h.*L.^4)./(8*E.*I) +...
    (P.*L.^3)./(3*E.*I);